package edu.uky.ai.ml.nn;

/**
 * An error function quantifies the difference between an expected value and
 * an actual value.  This particular error function is called the sum squared
 * error.
 * 
 * @author Stephen G. Ware
 */
public abstract class Error {

	/**
	 * Calculates the sum squared error of two vectors of equal length.
	 * 
	 * @param v1 first vector
	 * @param v2 second vector
	 * @return the sum squared error
	 */
	public static final double evaluate(double[] v1, double[] v2) {
		if(v1.length != v2.length)
			throw new IllegalArgumentException("Vectors must be of equal length.");
		double sum = 0;
		for(int i=0; i<v1.length; i++)
			sum += (v1[i] - v2[i]) * (v1[i] - v2[i]);
		return sum;
	}
}
